let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
$$.mdb = require('/agorum/roi/customers/cdev.ncore/js/utils/mdb')($$);

let metadb = require('common/metadb');
let aguila = require('common/aguila');
let message = require('/agorum/roi/customers/agorum.composite/js/lib/message');

// let utils = require('../idx-utils');
let init = require('/agorum/roi/customers/isg.xpert.archive/js/archive-init');

// const RECORD_COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter/records';
// const DOCUMENT_COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter/documents';
const COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter';
const CONFIG = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/config';

let enableDebugging = (flag) => {
  if ( flag ) {
    $$.enable({ package: 'isg.xpert.archive' });
  } else {
    $$.disable({ package: 'isg.xpert.archive' });
  }
  $$.debug('init-archive - enableDebugging', flag, $$.list());
};

let saveConfig = value => {
  $$.debug('init-archive - saveConfig', value );
  $$.mdb.save(CONFIG, {
    prefix: value.prefix,
    server: value.server,
    debug: value.debug,
    logging: value.logging,
    initialize: value.initialize,
    charset: value.charset,
    blocksize: value.blocksize.toString(),
    blockcount: value.blockcount.toString(),
  });
};

let widget = aguila.create({
  type: 'agorum.composite.form.basic',
  width: 500,
  height: 320,
  // labelPosition: 'top',
  labelWidth: 300,
  elements: [
    {
      type: 'agorum.composite.form.element.select',
      name: 'blocksize',
      label: 'Max. Anzahl Dokumente / Verzeichnis',
      restricted: true,
      data: [
        { text: '10', value: 1 },
        { text: '100', value: 2 },
        { text: '1000', value: 3 },
      ],
    },
    {
      type: 'agorum.composite.form.element.number',
      name: 'blockcount',
      label: 'Anzahl der Verzeichnisebenen',
    },
    {
      type: 'agorum.composite.form.element.select',
      name: 'charset',
      label: 'Zeichensatz für Indexdaten',
      data: ['ISO-8859-15', 'UTF-8'].map(item => {
        return { text: item, value: item };
      }),
    },
    {
      type: 'agorum.composite.form.element.text',
      name: 'server',
      label: 'URL für diesen Server',
    },
    {
      type: 'agorum.composite.form.element.boolean',
      name: 'debug',
      label: 'Console log aktivieren',
      // text: 'an/aus',
    },
    {
      type: 'agorum.composite.form.element.boolean',
      name: 'logging',
      label: 'Server log aktivieren',
      // text: 'an/aus',
    },
    {
      type: 'agorum.composite.form.element.boolean',
      name: 'initialize',
      label: 'Archiv initialisieren',
      hidden: true,
      // text: 'an/aus',
    },
    {
      type: 'agorum.composite.form.element.number',
      name: 'limit',
      label: 'Anzahl der Testdaten',
    },
    {
      type: 'agorum.composite.form.element.text',
      name: 'filter',
      label: 'Filter für Testdaten (Dateiname)',
    },
    {
      type: 'agorum.composite.form.element.text',
      name: 'documents',
      readOnly: true,
      label: 'Akt. Anzahl der Dokumente',
    },
    {
      type: 'agorum.composite.form.element.text',
      name: 'records',
      readOnly: true,
      label: 'Akt. Anzahl der Versicherten',
    },
    {
      type: 'agorum.spacer',
      flexible: true,
    },
    {
      type: 'agorum.hbox',
      items: [
        {
          type: 'agorum.composite.form.element.button',
          name: 'btnInit',
          text: 'Initialize',
          tooltip: 'Alle Archivdaten löschen und Zähler zurücksetzen',
        },
        {
          type: 'agorum.composite.form.element.button',
          name: 'btnLoad',
          text: 'Load data',
          tooltip: 'Archiv initalisieren und Testdaten laden',
        },
        {
          type: 'agorum.composite.form.element.button',
          name: 'btnUrl',
          text: 'Bookmark',
          tooltip: 'Beispiel URL für externen Zugriff anzeigen',
        },
        {
          type: 'agorum.composite.form.element.button',
          name: 'btnSave',
          text: 'Save',
          tooltip: 'Beispiel URL für externen Zugriff anzeigen',
        },
        {
          type: 'agorum.spacer',
          flexible: true,
        },
        {
          type: 'agorum.composite.form.element.button',
          name: 'btnCancel',
          text: 'Abbruch',
          tooltip: 'Hint',
          width: 185,
        },
      ],
    },
  ],
});

widget.down('server').on('input', data => {
  metadb.write(CONFIG + '/server', data.value);
});

widget.down('charset').on('input', data => {
  metadb.write(CONFIG + '/charset', data.value);
});

widget.down('filter').on('input', data => {
  widget.down('limit').value = init.countData({ filter: data.value });
});

widget.down('debug').on('input', data => {
  enableDebugging(data.value);
});

widget.on('action', data => {
  switch (data.name) {
    case 'btnCancel':
      widget.form.close();
      break;
    case 'btnUrl':
      message.alert(
        'Beispiel URL für externen Zugriff auf eine Versichertenakte',
        init.sampleUrl(widget.down('server').value),
        750
      );
      break;
    case 'btnInit':
      message.confirm('*** ACHTUNG ***', 'Alle Archivdaten löschen und Zähler zurücksetzen?').then(state => {
        if (state) {
          saveConfig(widget.value);
          aguila.fork(() => {
            init.clearArchive();
          });
          widget.form.close();
        }
      });
      break;
    case 'btnSave':
      message.confirm('*** ACHTUNG ***', 'Neue Einstellungen speichern?').then(state => {
        if (state) {
          saveConfig(widget.value);
          widget.form.close();
        }
      });
      break;
    case 'btnLoad':
      message
        .confirm(
          '*** INFO ***',
          '{0} Testdokumente archivieren?'.format(widget.value['limit'])
        )
        .then(state => {
          if (state) {
            saveConfig(widget.value);
            aguila.fork(() => {
              // init.clearArchive();
              init.copyData('import', {
                limit: widget.down('limit').value,
                filter: widget.down('filter').value,
              });
            });
            widget.form.close();
          }
        });
      break;
  }
});

setImmediate(() => {
  widget.form.title = 'Archiv initialisieren';
  widget.value = Object.assign($$.mdb.load(CONFIG), $$.mdb.load(COUNTER));
  enableDebugging(widget.value['debug']);
  widget.down('limit').value = init.countData();
  // if (parseInt(widget.down('documents').value) > 499 || parseInt(widget.down('records').value) > 100) { }
  if (!widget.down('initialize').value) {
    widget.down('blocksize').disabled = true;
    widget.down('blockcount').disabled = true;
    widget.down('limit').disabled = true;
    widget.down('filter').disabled = true;
    widget.down('btnInit').disabled = true;
    widget.down('btnLoad').disabled = true;
  }
});

widget;
